/* --------------------------------------------------------------
  Setting.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

/**
 * Class Setting
 */
export default class Setting {
	/**
	 * Class Constructor
	 */
	constructor() {
		/**
		 * Group
		 *
		 * @type {String}
		 */
		this.group = null;
		
		/**
		 * Name
		 *
		 * @type {String}
		 */
		this.name = null;
		
		/**
		 * Title
		 *
		 * @type {String}
		 */
		this.title = null;
		
		/**
		 * Type
		 *
		 * @type {String}
		 */
		this.type = null;
		
		/**
		 * Value
		 *
		 * @type {*}
		 */
		this.value = null;
		
		/**
		 * Default Metric
		 *
		 * @type {String}
		 */
		this.defaultMetric = null;
		
		/**
		 * Options
		 *
		 * @type {String[]}
		 */
		this.options = null;
		
		/**
		 * Tags
		 *
		 * @type {String[]}
		 */
		this.tags = null;
	}
	
	/**
	 * Group Getter
	 *
	 * @return {String}
	 */
	getGroup() {
		return this.group;
	}
	
	/**
	 * Name Setter
	 *
	 * @param {String} group
	 *
	 * @return {Setting}
	 */
	setGroup(group) {
		StyleEdit.Validator.isString(group);
		this.group = group;
		return this;
	}
	
	/**
	 * Name Getter
	 *
	 * @return {String}
	 */
	getName() {
		return this.name;
	}
	
	/**
	 * Name Setter
	 *
	 * @param {String} name
	 *
	 * @return {Setting}
	 */
	setName(name) {
		StyleEdit.Validator.isString(name);
		this.name = name;
		return this;
	}
	
	/**
	 * Title Getter
	 *
	 * @return {String}
	 */
	getTitle() {
		return this.title;
	}
	
	/**
	 * Title Setter
	 *
	 * @param {String} title
	 *
	 * @return {Setting}
	 */
	setTitle(title) {
		StyleEdit.Validator.isString(title);
		this.title = title;
		return this;
	}
	
	/**
	 * Type Getter
	 *
	 * @return {String}
	 */
	getType() {
		return this.type;
	}
	
	/**
	 * Type Setter
	 *
	 * @param {String} type
	 *
	 * @return {Setting}
	 */
	setType(type) {
		StyleEdit.Validator.isString(type);
		this.type = type;
		return this;
	}
	
	/**
	 * Value Getter
	 *
	 * @return {*}
	 */
	getValue() {
		return this.value;
	}
	
	/**
	 * Value Setter
	 *
	 * Notice: The value argument can be mixed so there is no validation.
	 *
	 * @param {*} value
	 *
	 * @return {Setting}
	 */
	setValue(value) {
		this.value = value;
		return this;
	}
	
	/**
	 * Default Metric Getter
	 *
	 * @return {String}
	 */
	getDefaultMetric() {
		return this.defaultMetric;
	}
	
	/**
	 * Default Metric Setter
	 *
	 * @param {String} defaultMetric
	 *
	 * @return {Setting}
	 */
	setDefaultMetric(defaultMetric) {
		this.defaultMetric = defaultMetric;
		return this;
	}
	
	/**
	 * Options Getter
	 *
	 * @return {String[]}
	 */
	getOptions() {
		return this.options;
	}
	
	/**
	 * Options Setter
	 *
	 * @param {String[]} options
	 *
	 * @return {Setting}
	 */
	setOptions(options) {
		StyleEdit.Validator.isObject(options);
		this.options = options;
		return this;
	}
	
	/**
	 * Tags Getter
	 *
	 * @return {String[]}
	 */
	getTags() {
		return this.tags;
	}
	
	/**
	 * Tags Setter
	 *
	 * @param {String[]} tags
	 *
	 * @return {Setting}
	 */
	setTags(tags) {
		StyleEdit.Validator.isObject(tags);
		this.tags = tags;
		return this;
	}
}
